{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.10.98 - 13:38:44 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  MMObj,
  MMUtils,
  MMCstDlg,
  MMDesign,
  MMWave,
  MMWavOut,
  MMDIBCv,
  MMLevel,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMwaveIO,
  MMRingBf,
  MMHTimer,
  MMSlider,
  MMSpectr,
  MMSystem,
  MMHook;

type
  TForm1 = class(TForm)
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMConnector2: TMMConnector;
    WaveOut: TMMWaveOut;
    PlayFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    Label1: TLabel;
    StopBtn: TButton;
    PlayBtn: TButton;
    OpenDialog: TMMWaveOpenDialog;
    Timer: TMMHiTimer;
    TrackBar: TMMSlider;
    procedure PlayBtnClick(Sender: TObject);
    procedure DeviceStart(Sender: TObject);
    procedure DeviceStop(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure TrackBarTrack(Sender: TObject);
    procedure TrackBarTrackEnd(Sender: TObject);
    procedure WaveOutBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
  private
    Seeking: Boolean;
    StartPos: Longint;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This Demo swaps the left and right channel on the fly during playback }

{------------------------------------------------------------------------------}
procedure TForm1.StopBtnClick(Sender: TObject);
begin
   { close and stop all devices }
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.PlayBtnClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      PlayFile.Wave.FileName := OpenDialog.FileName;
      TrackBar.MaxValue := PlayFile.Wave.DataSize;
      TrackBar.Position := 0;

      Seeking := False;

      StartPos:= TrackBar.Position;

      { start playing }
      WaveOut.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DeviceStart(Sender: TObject);
begin
   StopBtn.Enabled := True;
   PlayBtn.Enabled := False;
   Timer.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DeviceStop(Sender: TObject);
begin
   Timer.Enabled := False;

   StopBtn.Enabled := False;
   PlayBtn.Enabled := True;

   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { don't forgot to close the devices at the end }
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TimerTimer(Sender: TObject);
var
   Time: Longint;
begin
   Time := StartPos+WaveOut.Position;
   if not Seeking then TrackBar.Position:= Time;

   if not Seeking then Label1.Caption := TimeToString(Time);
end;

{------------------------------------------------------------------------------}
procedure TForm1.TrackBarTrack(Sender: TObject);
begin
   Seeking := True;
   Label1.Caption := TimeToString(TrackBar.Position);
end;

{------------------------------------------------------------------------------}
procedure TForm1.TrackBarTrackEnd(Sender: TObject);
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOut.Pause;
      StartPos := TrackBar.Position;
      PlayFile.Wave.Position := StartPos;
      WaveOut.Reset;
      WaveOut.Restart;
   end;
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
type
    PSample = ^TSample;
    TSample = record
       chLeft: Smallint;
       chRight: Smallint;
    end;
var
   nBytes: Longint;
   Temp: Smallint;
   p: PSample;
begin
   { this event occurs directly before the data is sent to the dirver }

   { in this demo we use it to swap the left and right channel }
   if (WaveOut.PWaveFormat.wFormatTag = WAVE_FORMAT_PCM) and
      (Waveout.PWaveFormat.nChannels = 2) and
      (Waveout.PWaveFormat.wBitsPerSample = 16) then
   begin
      // we support only 16 Bit Stereo in this demo
      nBytes := lpWaveHdr.dwBytesRecorded;
      p := Pointer(lpWaveHdr.lpData);
      while (nBytes > 0) do
      begin
         // swap the channels
         Temp := p.chleft;
         p.chLeft :=  p.chRight;
         p.chRight := Temp;
         // advance to the next sample block
         inc(p);
         // decrease our byte counter
         dec(nBytes,4);
      end;
   end;
end;

end.
